

<?php $__env->startSection('title'); ?>
Dashboard | Shipments 
<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
<div class="container-fluid">
    <ol class="breadcrumb mb-2 mt-4">
            <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
            <li class="breadcrumb-item active">Shipments Management</li>
        </ol>
      
     
     <div class="row">
          <div class="col-lg-12">
            <div class="card">
              <div class="card-header"><i class="fa fa-table"></i> Shipments Report</div>
              <div class="card-body">
                <div class="table-responsive">
                  <table id="example" class="table table-bordered">
                    <thead>
                     <tr>
                        <th>Sl No</th>
                        <th>Inbound Order ID</th>
                        <th>Shipment ID</th>
                        <th>Create Date</th>
                        <th>Shipment Units</th>
                        <th>Received Units</th>
                         <th>Fill Rate %</th>
                        <th>Expected Date</th>
                        <th>Actual Delivery</th>
                        <th>Delivered on</th>
                        <th>Status</th>
                        <th>Tracking</th>
                        
                       
                    </tr>
                    </thead>
                    <tbody>
                      <?php if(!empty($response)): ?>
                   <?php
                       $sl = 1;
                   ?>
                     <?php $__currentLoopData = $response['payload']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    
                     <tr>
                      <td><?php echo e($sl++); ?></td>
                      <td><?php echo e($value['inboundOrderId']); ?></td>
                      
                      <td><a target="_blank" href="<?php echo e(url('shipments/items/'.$value['shipmentId'])); ?>"><?php echo e($sId = $value['shipmentId']); ?></a></td>
                      <td><?php echo e(date('Y-m-d', strtotime($value['createdDate']))); ?></td>
                      <td><?php echo e($shipUnit = $value['shipmentUnits']); ?></td>
                      <td><?php echo e($rcvUnit = $value['receivedUnits']); ?></td>
                      <?php
                        if($rcvUnit!=0){
                        $perc = ($rcvUnit/$shipUnit)*100;
                        $fillRate = number_format($perc,2)."%";
                        }
                      
                      ?>
                      <?php if($rcvUnit == 0): ?>
                           <td class="text-warning"> 0.00% </td>
                      <?php else: ?>
                          <td><?php if($fillRate<100){echo "<span class='text-danger'>".$fillRate."</span>";}else{echo $fillRate;}?></td>
                      <?php endif; ?>
                      
                      
                      <td><?php echo e(date('d-M-Y', strtotime($value['expectedDeliveryDate']))); ?></td>
                      
                      
                      <?php if(!empty($value['actualDeliveryDate'])): ?>
                
                      <td><?php echo e($actualDate = date('d-M-Y', strtotime($value['actualDeliveryDate']))); ?></td>

                      <td><?php echo e(Carbon\Carbon::createFromTimestamp(strtotime($actualDate))->diff(\Carbon\Carbon::now())->days." days ago"); ?></td>
                      
                      <?php else: ?>
                        <td>-</td>
                        <td>-</td>
                       <?php endif; ?>
                       
                       
                      <td><?php echo e($value['status']); ?></td>
                      
        
                     <?php if(!empty($value['trackingNo'])): ?>
                       <td>
                           <a href="https://www.fedex.com/fedextrack/?tracknumbers=<?php echo e($value['trackingNo'][0]); ?>" target="_blank" >Track Shipment</a>
                       </td>
                      <?php else: ?>
                      <td>
                          -
                      </td>
                      <?php endif; ?>
                      
                     </tr>
                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   
                      
          
    
                    <?php endif; ?>
                    </tbody>
                   
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
</div>
<?php $__env->stopSection(); ?>
               
<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hidatxwl/smartwfs.com/resources/views/admin/shipment/index.blade.php ENDPATH**/ ?>