

<?php $__env->startSection('title'); ?>
Dashboard | Employees 
<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
<div class="container-fluid">
    <ol class="breadcrumb mb-2 mt-4">
            <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
            <li class="breadcrumb-item active">Employees Management</li>
        </ol>
        <div>
            <a href="<?php echo e(url('employee/create')); ?>" type="button" class="btn btn-sm btn-info waves-effect waves-light mb-2"> <i class="fa fa-plus"></i> Add New</a>
        <div>
     
     <div class="row">
          <div class="col-lg-12">
            <div class="card">
              <div class="card-header"><i class="fa fa-table"></i> Employees Management</div>
              <div class="card-body">
                <div class="table-responsive">
                  <table id="example" class="table table-bordered">
                    <thead>
                     <tr>
                        <th>Sl No</th>
                        <th>Name</th>
                        <th>ID</th>
                        <th>Phone</th>
                        <th>Designation</th>
                        <th class="text-center">Photo</th>
                        <th class="text-center">Option</th>
                    </tr>
                    </thead>
                    <tbody>
                       <?php ($sl=1); ?>
                       <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                            <tr>
                                <td><?php echo e($sl++); ?></td>
                                <td><?php echo e($employee->employee_name); ?></td>
                                <td><?php echo e($employee->id_card_no); ?></td>
                                <td><?php echo e($employee->phone); ?></td>
                                <td><?php echo e($employee->designation_name); ?></td>
                                <td class="text-center">

                                 <img class="img-center rounded-circle border border-black" style= 'height: 40px; width: 40px;' src="<?php echo e(asset('employee/photos/'.$employee->employee_photo)); ?>" alt="">

                                </td>
                                <td class="text-center">
                                    <div class="dropdown show">
                <a class="btn btn-sm btn-info dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    Action
                </a>
                <div class="dropdown-menu text-center" aria-labelledby="dropdownMenuLink">
                  <a href="<?php echo e(url('employee/view')); ?>/<?php echo e(\Crypt::encrypt(['id'=>$employee->id])); ?>" class="btn btn-sm btn-primary ml-1" title="View"><i class="fa fa-eye"></i></a>

                  <a href="<?php echo e(url('employee/edit')); ?>/<?php echo e(\Crypt::encrypt(['id'=>$employee->id])); ?>" class="btn btn-sm btn-secondary" title="Edit"><i class="fa fa-edit"></i></a>

                  <a href="<?php echo e(url('employee/delete',['id'=>$employee->id])); ?>"  class="btn btn-sm  btn-danger" onClick="return confirm('Are you sure want to delete?')" title="Delete"><i class="fa fa-trash"></i></a>

                </div>
            </div>


                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                           
                    </tbody>
                    <tfoot>
                        <tr>
                          <th>Sl No</th>
                          <th>Name</th>
                          <th>ID</th>
                          <th>Phone</th>
                          <th>Designation</th>
                          <th>Photo</th>
                          <th>Option</th>
                        </tr>
                    </tfoot>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
</div>
<?php $__env->stopSection(); ?>
               
<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\automation\resources\views/admin/employees/index.blade.php ENDPATH**/ ?>