

<?php $__env->startSection('title'); ?>
Settings | Users Management
<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
<div class="container-fluid">
    <ol class="breadcrumb mb-2 mt-2">
            <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
            <li class="breadcrumb-item active">Users Management</li>
        </ol>
        <div>
             <?php if(auth()->user()->hasPermission('user.create')): ?>
            <a href="<?php echo e(route('user.create')); ?>" type="button" class="btn btn-sm btn-info waves-effect waves-light mb-2"> <i class="fa fa-plus"></i> Add New</a>
             <?php endif; ?>
        <div>
     
     <div class="row">
          <div class="col-lg-12">
            <div class="card">
              <div class="card-header"><i class="fa fa-table"></i> Users Management</div>
              <div class="card-body">
                <div class="table-responsive">
                  <table id="example" class="table table-bordered">

                    <thead>
                     <tr>
                        <th>Sl No</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Store Name</th>
                        <th>Client ID</th>
                        <th>Client Secret</th>
                        <th>Online</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key + 1); ?></td>
                        <td>
                        <div class="widget-content-right flex-2">
                            <div class="widget-heading"><?php echo e($user->name); ?></div>
                            <div class="widget-subheding opacity-6">
                                <?php if($user->role): ?>
                                    <span class="badge badge-info"><?php echo e($user->role->name); ?></span>
                                        <?php else: ?>
                                        <span class="badge badge-info">No role found</span>
                                        <?php endif; ?>
                            </div>
                        </div>
                        </td>

                        <td><?php echo e($user->email); ?></td>

                        <td><?php echo e($user->store_name); ?></td>
                        <td><input type="password" readonly value="<?php echo e($user->client_id); ?>"></td>
                        <td><input type="password" readonly value="<?php echo e($user->client_secret); ?>"></td>
                        <td>
                                    <?php if($user->isOnline()): ?>
                                    <span class="badge badge-success m-1">online</span>
                                    <?php else: ?>
                                    <span class="badge badge-warning m-1">offline</span>
                                    <?php endif; ?>
                                
                        </td>
                        <td><?php echo e($user->status == 1?'Active':'Inactive'); ?></td>
                        <td>
                                    <?php if(auth()->user()->hasPermission('user.edit')): ?>
                                    <a href="<?php echo e(route('user.edit', $user->id)); ?>" class="btn btn-sm btn-info float-left mr-1">
                                        <i class="fa fa-edit"></i>
                                        <span>Edit</span>
                                    </a>
                                    <?php else: ?>
                                    <button type="button" class="btn btn-sm btn-secondary float-left mr-1" disabled><i class="fa fa-edit"></i>
                                        <span>Edit</span></button>

                                    <?php endif; ?>
 
                                    <?php if($user->role->deletable): ?>
                                        <?php if(auth()->user()->hasPermission('user.destroy')): ?>
                                       <form id="delete-form-<?php echo e($user->id); ?>"
                                                action="<?php echo e(route('user.destroy',$user->id)); ?>" method="POST"
                                               >
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button onclick="if (!confirm('Are you sure to delete?')) { return false }" type="submit" class="btn btn-danger btn-sm">
                                                <i class="fas fa-trash-alt"></i>
                                                <span>Delete</span>
                                            </button>
                                            </form>
                                        <?php else: ?>
                                        <button type="button" class="btn btn-sm btn-secondary " disabled><i class="fas fa-trash-alt"></i>
                                            <span>Delete</span></button>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <button type="button" class="btn btn-sm btn-danger " disabled><i class="fas fa-trash-alt"></i>
                                        <span>Delete</span></button>
                                    <?php endif; ?>
                                </td>
                    </tr>
                    
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     
                    </tbody>
                    <tfoot>
                        <th>Sl No</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Store Name</th>
                        <th>Client ID</th>
                        <th>Client Secret</th>
                        <th>Online</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tfoot>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
</div>
<?php $__env->stopSection(); ?>
               
<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hidatxwl/smartwfs.com/resources/views/admin/users/index.blade.php ENDPATH**/ ?>