<?php

use App\Http\Controllers\AbsentController;
use App\Http\Controllers\AdminPanelController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\DesignationController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\SalaryController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\NightController;
use App\Http\Controllers\OffdayController;
use App\Http\Controllers\LeaveController;
use App\Http\Controllers\UnitController;

use App\Http\Controllers\ShipmentController;
use App\Http\Controllers\InventoryController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ProfitController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\PurchaseController;
use App\Http\Controllers\ItemsReportController;

use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ImportExcelController;
use App\Http\Controllers\DatabaseBackupController;
use App\Http\Controllers\VisitorController; 
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
}); 


 Route::get('/check',[InventoryController::class, 'itemChecker']);
 Route::post('/check',[InventoryController::class, 'Checker']);




Route::group(['middleware' => ['auth']], function(){
    Route::get('/dashboard',[AdminPanelController::class, 'dashboard']);
    Route::get('/get-today-sales', [AdminPanelController::class, 'getTodaySales']);
    
    Route::get('/update-chart-data', [AdminPanelController::class, 'updateChartData'])->name('update.chart.data');


    

    Route::Resource('role',RoleController::class);
    Route::Resource('user',UserController::class);
    //Designation Routes start here
    Route::group(['prefix'=>'/settings/designation'],function(){
        Route::get('index',[DesignationController::class, 'index']);
        Route::post('save',[DesignationController::class, 'saveDesignation']);
        Route::get('edit/{id}',[DesignationController::class, 'editDesignation']);
        Route::post('update',[DesignationController::class, 'updateDesignation']);
        Route::get('delete/{id}',[DesignationController::class, 'deleteDesignation']);
    });
    //Designation Routes end here

 

     //Shipments Routes start here
     Route::group(['prefix'=>'/shipments'],function(){
        Route::get('report',[ShipmentController::class, 'shipmentReport']);
        Route::get('shipitems',[ShipmentController::class, 'shipItems']);
        Route::get('items/{shipmentId}',[ShipmentController::class, 'shipmentItems']);
        Route::get('opencase/{shipmentId}',[ShipmentController::class, 'openCase']);
        Route::get('shipped/{shipmentId}',[ShipmentController::class, 'shipmentItems']);
        
    });
    
    
    //Shipments Routes end here

    //Inventory Routes start here
    Route::group(['prefix'=>'/inventory'],function(){
        Route::get('report',[InventoryController::class, 'inventoryReport']);
        
    });
    //Inventory Routes end here

    //Products Routes start here
    Route::group(['prefix'=>'/product'],function(){
        Route::get('index',[ProductController::class, 'indexProduct']);
        Route::get('view',[ProductController::class, 'viewProduct']); 
        
        Route::get('value',[ProductController::class, 'stockValue']); 
        
    });
    //Products Routes end here

    //Profit Routes start here
    Route::group(['prefix'=>'/profit'],function(){
        // Route::get('index',[ProfitController::class, 'indexProfit']);
        Route::get('report',[ProfitController::class, 'proReport']);
        Route::post('reports',[ProfitController::class, 'reportsProfit']);
        
         Route::get('sync',[ProfitController::class, 'syncOrders']);
         
         
       
    });
    //Profit Routes end here
    Route::get('syncorder', [ProfitController::class, 'ordersSync']);



    //Orders Routes start here
    Route::group(['prefix'=>'/orders'],function(){
        Route::get('report',[OrderController::class, 'orderReport']);
        
    });
    //Orders Routes end here

    //Import Routes start here
    Route::group(['prefix'=>'/import'],function(){
        Route::get('manage',[ImportExcelController::class, 'manageFee']);
        Route::get('wfsfee',[ImportExcelController::class, 'wfsFee']);

        Route::post('feewfs',[ImportExcelController::class, 'feeWFS']);
        
        Route::get('buyboxreport',[ImportExcelController::class, 'buyboxreport']);
        Route::post('buyboxReport',[ImportExcelController::class, 'boxReport']);
        
        Route::get('payreport',[ImportExcelController::class, 'payReport']);
        Route::post('payreport',[ImportExcelController::class, 'uploadPayReport']);
        
        
        Route::get('itemprice',[ImportExcelController::class, 'itemPrice']);
        Route::post('itemprice',[ImportExcelController::class, 'uploadItemPrice']);
        
    });
    //Import Routes end here
    
    //Buybox Routes start here
    Route::group(['prefix'=>'/buybox'],function(){
        Route::get('items',[ItemsReportController::class, 'manageBuybox']);
        Route::get('automate',[ItemsReportController::class, 'automateBuybox']);
        
        Route::get('blacklist',[ItemsReportController::class, 'blackList']);
        Route::post('addtolist',[ItemsReportController::class, 'addToBlackList']);
        
       
       
      
    });
    //Buybox Routes end here
   Route::get('buybox/delete/{id}', [ItemsReportController::class, 'deleteBlacklistItem'])->name('deleteItem');
    


    //Purchase Routes start here
    Route::group(['prefix'=>'/purchase'],function(){
        Route::get('add_new',[PurchaseController::class, 'addPurchase']);
        Route::get('reports',[PurchaseController::class, 'reportPurchase']);

        // Route::get('admin/api/product','PurchaseController@getAutocompleteData'); 
    });

    
        // Route::get('admin/api/product',[PurchaseController::class, 'getAutocompleteData']);
      
      
      Route::post('dynamic-field/buybox', [ItemsReportController::class,'updatePrice'])->name('dynamic-field.buybox');


        Route::post('dynamic-field/insert', [PurchaseController::class,'insert'])->name('dynamic-field.insert');
        Route::post('dynamic-field/update', [PurchaseController::class,'update'])->name('dynamic-field.update');

        Route::post('dynamic-field/feeupdate', [ImportExcelController::class,'update'])->name('dynamic-field.feeupdate');

        Route::get('pro/report', [ProfitController::class,'reportProfit'])->name('pro.report');
      
        // Route::post('dynamic-field/update', [DynamicFieldController::class,'update'])->name('dynamic-field.update');
        
        Route::post('/update-wfs-fee', [PurchaseController::class, 'updateWfsFee'])->name('update-wfs-fee');
    
  
   
    //Purchase Routes end here













    //Department Routes start here
    Route::group(['prefix'=>'/settings/department'],function(){
        Route::get('index',[DepartmentController::class, 'index']);
        Route::post('save',[DepartmentController::class, 'saveDepartment']);
        Route::get('edit/{id}',[DepartmentController::class, 'editDepartment']);
        Route::post('update',[DepartmentController::class, 'updateDepartment']);
        Route::get('delete/{id}',[DepartmentController::class, 'deleteDepartment']);
    });
    //Department Routes end here

     //Department Routes start here
     Route::group(['prefix'=>'/settings/unit'],function(){
        Route::get('index',[UnitController::class, 'index']);
        Route::post('save',[UnitController::class, 'saveUnit']);
        Route::get('edit/{id}',[UnitController::class, 'editUnit']);
        Route::post('update',[UnitController::class, 'updateUnit']);
        Route::get('delete/{id}',[UnitController::class, 'deleteUnit']);
    });
    //Department Routes end here

    //Employee Route start here
     Route::group(['prefix'=>'/employee'],function(){
        Route::get('index',[EmployeeController::class, 'index']);
        Route::get('create',[EmployeeController::class, 'createEmployee']);
        Route::post('save',[EmployeeController::class, 'saveEmployee']);
        Route::get('delete/{id}',[EmployeeController::class, 'deleteEmployee']);
        Route::get('edit/{id}',[EmployeeController::class, 'editEmployee']);
        Route::post('update',[EmployeeController::class, 'updateEmployee']);
        Route::get('view/{id}',[EmployeeController::class, 'viewEmployee']);

        
    });
    //Employee Route end here

     //Salary Route start here
     Route::group(['prefix'=>'/salary'],function(){
        Route::get('add_salary',[SalaryController::class, 'addSalary']);
        Route::post('add_salary',[SalaryController::class, 'addSalary']);
        Route::post('save',[SalaryController::class, 'saveSalary']);
    });
    //Salary Route end here

     //Salary Route start here
     Route::group(['prefix'=>'/night'],function(){
         Route::get('add_night',[NightController::class, 'addNight']);
         Route::post('add_night',[NightController::class, 'addNight']);
         Route::post('save',[NightController::class, 'saveNight']);
       
    });
    //Salary Route end here


    Route::group(['prefix'=>'/absent'],function(){
        Route::get('create',[AbsentController::class, 'addAbsent']);
        Route::post('create',[AbsentController::class, 'addAbsent']);
        Route::post('save',[AbsentController::class, 'saveAbsent']);
   });

     Route::group(['prefix'=>'/offday'],function(){
        Route::get('create',[OffdayController::class, 'addOffday']);
        Route::post('create',[OffdayController::class, 'addOffday']);
        Route::post('save',[OffdayController::class, 'saveOffday']);
   });

    Route::group(['prefix'=>'/leaveday'],function(){
            Route::get('create',[LeaveController::class, 'addLeaveday']);
            Route::post('create',[LeaveController::class, 'addLeaveday']);
            Route::post('save',[LeaveController::class, 'saveLeaveday']);
       });

    Route::group(['prefix'=>'/visitor'],function(){
       Route::get('index',[VisitorController::class,'index']);
       Route::post('save',[VisitorController::class,'visitorSave']);
       Route::get('outtime/{visitorId}',[VisitorController::class,'outTime']);
       Route::get('edit/{visitorId}',[VisitorController::class,'visitorEdit']);
       Route::post('update',[VisitorController::class,'visitorUpdate']);
       Route::get('delete/{visitorId}',[VisitorController::class,'visitorDelete']);

       Route::get('report_by',[VisitorController::class,'visitorReportBy']);
       Route::post('reports',[VisitorController::class,'visitorReports']);

   });


     //Reports Controller Start Here
      Route::group(['prefix'=>'/reports'],function(){
         Route::get('salary_sheet',[ReportController::class, 'salarySheet']);
         Route::post('salary_report',[ReportController::class, 'salaryReport']);

        Route::get('pdf',[ReportController::class, 'PDF']);

         Route::get('pay_slip',[ReportController::class, 'paySlip']);
         Route::post('pay_slip_report',[ReportController::class, 'paySlipReport']);

         Route::get('salary_summary',[ReportController::class, 'salarySummary']);
         Route::post('salary_summary_report',[ReportController::class, 'salarySummaryReport']);

         Route::get('gen',[ReportController::class, 'gen']);
         Route::post('genarate',[ReportController::class, 'genarate']);
       
    });
     //Reports Controller End Here

      //Database Backup Controller
       Route::group(['prefix'=>'/database'],function(){
         Route::get('backup',[DatabaseBackupController::class, 'databaseBackup']);
       
        });
       //End Database Backup Controller

});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
