<!DOCTYPE html>
<html lang="en">
<head>
  <title>Existing Products Checker</title>
  <link rel="icon" href="img/favicon.png" type="image/x-icon">
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>

  	<script src="http://code.jquery.com/jquery-1.9.1.min.js"></script>
	<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.0.1/css/toastr.css" rel="stylesheet"/>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.0.1/js/toastr.js"></script>

</head>
<body>

<div class="container" style="margin-top: 30px;box-shadow: 8px 8px 8px 8px #888888;">
  <div style="margin: 10%;">
  	<h2 class="text-center">Existing Products Checker</h2>
  	<form class="form-horizontal" method="post" action="{{ url('/check') }}">
  	     {{ csrf_field() }}
  	<div class="form-group">
      <label class="control-label col-sm-2" for="product">Product UPC:</label>
      <div class="col-sm-10">
        <input autocomplete="OFF" type="text" class="form-control" id="product" name="product_upc" required="1">
      </div>
    </div>

    <div class="form-group">        
      <div class="col-sm-offset-2 col-sm-10">
        <button type="submit" name="submit" class="btn btn-primary">Check</button>
      </div>
    </div>
  </form>
  </div>
</div>


@if (!empty($data)) 
@foreach($data as $item) 
    <div class="container" style="margin-top: 30px;box-shadow: 8px 8px 8px 8px #888888;border:dotted">
        <div style="margin: 2%;font-size:19px;" class="text-center">
            <span style="font-size:20px; font-weight: bold;" class="text-center text-danger">Item already exists in another store! Details Below</span>
            <table style="margin-top: 12px;"; class="table text-left">
                
                 <tr>
                    <td>Seller :  </td>
                    <td>{{ $item->storeName}}</td>
                </tr>
                
                <tr>
                    <td>Item GTIN :  </td>
                    <td>{{ $item->gtin}}</td>
                </tr>
                
                <tr>
                    <td>Item Name :  </td>
                    <td>{{ $item->itemDesc}}</td>
                </tr>
                
                <tr>
                    <td>Live On :  </td>
                    <td>{{ date('d-M-Y', strtotime($item->expectedDeliveryDate))}} - ( {{ \Carbon\Carbon::parse($item->expectedDeliveryDate)->diffForhumans() }} )</td>
                    
                </tr>
                
            </table>
        
        </div>
    </div>
   
    
    @endforeach
    
	<?php	echo "<script type=\"text/javascript\">
							toastr.error('<span>Product Already Exist!! &#129325</span>')
			  </script>";?>
	@else
	<?php	echo "<script type=\"text/javascript\">
							toastr.success('<span>Congratulations!! You can purchase this item. &#128526</span>')
			  </script>"; ?>
@endif


 <br/>


</body>
</html>
