
@extends('admin.master')
@section('title')
Visitors | Report
@endsection
@section('maincontent')
<div class="container-fluid pt-2">
     <div class="row">
        
          <div class="col-lg-12">
      
            <div class="card">

              <div class="card-body">
                <div class="table-responsive" id="printableArea">
                    <style>
                        table,tr,th,td{
                            border : 1px solid black;
                            color: black;
                        }
                    </style>
                    <h5 class="text-center text-uppercase p-0 m-0">Akbar Cotton Mills LTD</h5>
                    <h6 class="text-center">Jamirdia, Valuka, Mymensingh.</h6>
                    <h6 class="text-center text-bold p-0 m-0"> Visitor Report </h6>
                    <p class="text-center text-bold">{{date('d-m-Y', strtotime($reportDate->from_date))}} <b>to</b> {{date('d-m-Y', strtotime($reportDate->to_date))}}</p>
                  <table class="table">
                    <thead>
                     <tr>
                        <th>Sl No</th>
                        <th>Visitor Name</th>
                        <th>Visit Date</th>
                        <th>Out Date</th>
                        <th>Vehicle No</th>
                        <th>Description</th>
                        <th>In Time</th>
                        <th>Out Time</th>
                        <th class="text-right">Stay Duration</th>
                    </tr>
                    </thead>
                    @php($sl=1)
                    @foreach ($visitorsReport as $visitorReport)
                    <tbody>
                        <td>{{$sl++}}</td>
                        <td>{{$visitorReport->visitor_name}}</td>
                        <td>{{$visitDate = $visitorReport->visit_date}}</td>
                        <td>{{$outDate = $visitorReport->out_date}}</td>
                        <td>{{$visitorReport->vehicle_no}}</td>
                        <td>{{$visitorReport->description}}</td>
                        <td>{{$inTime = date('h:i:s a', strtotime($visitorReport->in_time))}}</td>
                        <td>{{$outTime = date('h:i:s a', strtotime($visitorReport->out_time))}}</td>
                        <td class="text-right">
                            <?php
                                $start = Carbon\Carbon::parse($inTime);
                                $end = Carbon\Carbon::parse($outTime);
                                $duration = $end->diffInSeconds($start); 

                                $startD = Carbon\Carbon::parse($visitDate);
                                $endD = Carbon\Carbon::parse($outDate);
                                $durationD = $endD->diffInDays($startD); 
                                
                            ?>
                            @if($durationD>0){{$durationD.' days | '.gmdate('H:i:s',$duration)}}
                            @else
                              {{gmdate('H:i:s',$duration)}}
                            @endif
                        </td>
                        
                      </tbody>
                    @endforeach
                  </table>
                </div>
              </div>
            
          
            </div>
            <a href="{{url('visitor/report_by')}}" class="btn btn-sm btn-dark pull-right mt-0 mt-2 "><i class="fa fa-arrow-circle-left"></i>  Back</a>
            <button onclick="printDiv('printableArea')" class="btn btn-sm btn-info pull-right mt-0 mt-2 "><i class="fa fa-print"></i>  Print</button>
        </div>
</div>

@endsection
@section('custom_js')
<script type="text/javascript">
    function printDiv(divName) {
         var printContents = document.getElementById(divName).innerHTML;
         var originalContents = document.body.innerHTML;
         document.body.innerHTML = printContents;
         window.print();
         document.body.innerHTML = originalContents;
         location.reload();
    }
    </script>
@endsection
               