
@extends('admin.master')
@section('title')
Settings | Visitor
@endsection
@section('maincontent')
<!-- CSS -->
<style>
#my_camera{
 width: 320px;
 height: 240px;
 border: 1px solid black;
}
</style>
<div class="container-fluid">
    <ol class="breadcrumb mb-2 mt-2">
            <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
            <li class="breadcrumb-item active">Visitor Management</li>
        </ol>
        <div>
            @if(auth()->user()->hasPermission('visitor.create'))
              <button type="button" class="btn btn-sm btn-info waves-effect waves-light mb-2" data-toggle="modal" data-target="#defaultsizemodal" data-backdrop="static" data-keyboard="false"> <i class="fa fa-plus"></i> Add New</button>
            @else
            <button type="button" class="btn btn-sm btn-info waves-effect waves-light mb-2" disabled> <i class="fa fa-plus"></i> Add New</button>
            @endif

            @if(auth()->user()->hasPermission('visitor.reports'))
              <a href="{{url('visitor/report_by')}}" type="button" class="btn btn-sm btn-primary waves-effect waves-light mb-2"> <i class="fas fa-chart-bar"></i> Reports</a>
            @endif

        <div>
     
     <div class="row">
          <div class="col-lg-12">
            <div class="card">
              <div class="card-header"><i class="fa fa-table"></i> Visitor Management</div>
              <div class="card-body">
                <div class="table-responsive">
                  <table id="example" class="table table-bordered">
                    <thead>
                     <tr>
                        <th>Sl No</th>
                        <th>Visitor Name</th>
                        <th>Visit Date</th>
                        <th>Vehicle No</th>
                       
                        <th>In Time</th>
                        <th>Out Time</th>
                        <th>Photo</th>
                        <th class="text-center">Option</th>
                    </tr>
                    </thead>
                    <tbody>
                      @php($sl=1)
                       @foreach ($visitors as $visitor)
                        @php($outTime = $visitor->out_time)
                       @if(!empty($visitor->out_time))
                        @php($outTime = date('h:i:s a', strtotime($visitor->out_time)))
                       @endif
                            <tr>
                                <td>{{$sl++}}</td>
                                <td>{{$visitor->visitor_name}}</td>
                                <td>{{$visitor->visit_date}}</td>
                                <td>{{$visitor->vehicle_no}}</td>
                                <td>{{date('h:i:s a', strtotime($visitor->in_time))}}</td>
                                <td>
                                  {{$outTime}}
                                </td>
                                <td>
                                  <img class="img-center border border-black" style= 'height: 40px; width: 40px;' src="{{asset('visitors/photos/'.$visitor->visitor_photo)}}" alt="">
                                </td>
                                <td class="text-center">
                                    <a href="{{url('visitor/outtime',['id'=>$visitor->id])}}" class="btn btn-sm btn-primary"><i class="fas fa-clock"></i></a>
                                  
                                  @if(auth()->user()->hasPermission('visitor.edit'))
                                    <a href="{{url('visitor/edit')}}/{{\Crypt::encrypt(['id'=>$visitor->id])}}" class="btn btn-sm btn-info"><i class="fas fa-edit"></i></a>
                                  @endif

                                  @if(auth()->user()->hasPermission('visitor.destroy'))
                                    <a href="{{url('visitor/delete',['id'=>$visitor->id])}}" class="btn btn-sm btn-danger" onClick="return confirm('Are you sure want to delete?')"><i class="fas fa-trash"></i></a>
                                  @endif

                                </td>
                            </tr>
                              
                       @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                          <th>Sl No</th>
                          <th>Visitor Name</th>
                          <th>Visit Date</th>
                          <th>Vehicle No</th>
                        
                          <th>In Time</th>
                          <th>Out Time</th>
                          <th>Photo</th>
                          <th class="text-center">Option</th>
                        </tr>
                    </tfoot>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
</div>
<div class="modal fade" id="defaultsizemodal">
        <div class="modal-dialog modal-dialog-centered">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title">Add New Visitor</h5>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
        <div class="col-md-12">
            <div class="modal-body">
                <div class="card">
                          <div class="row justify-content-center">
                              <div class="col-lg-12">
                                  <div class="card shadow-lg border-0 rounded-lg">
                                      <div class="card-body">
                                          <form action="{{url('visitor/save')}}" method="POST" enctype="multipart/form-data">
                                              @csrf
                                              <div class="form-group">
                                                  <input class="form-control py-4 mb-1" name="card_no" type="text" placeholder="Card No" />
                                                  <input class="form-control py-4 mb-1" name="visitor_name" type="text" placeholder="Visitor Name" />
                                                  <input class="form-control py-4 mb-1" name="vehicle_no" type="text" placeholder="Vehicle No" />
                                                  <textarea class="form-control py-4 mb-1" name="description" placeholder="Description"></textarea>
                                                  
<div style="width: 100%; height:50px" id="my_camera"></div>
<div class="mt-1 mb-1">
  <input type=button class ="btn btn-sm btn-dark" value="Capture" onClick="take_snapshot()">
  <input type="file"  name="visitor_photo" accept="image/*">
</div>

                                                   
<div id="results" ></div>
 
<!-- Webcam.min.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/webcamjs/1.0.26/webcam.min.js" integrity="sha512-dQIiHSl2hr3NWKKLycPndtpbh5iaHLo6MwrXm7F0FM5e+kL2U16oE9uIwPHUl6fQBeCthiEuV/rzP3MiAB8Vfw==" crossorigin="anonymous"></script>

<!-- Configure a few settings and attach camera -->
<script language="JavaScript">
 Webcam.set({
  width: 250,
  height: 180,
  image_format: 'jpeg',
  jpeg_quality: 300
 });
 Webcam.attach( '#my_camera' );

<!-- Code to handle taking the snapshot and displaying it locally -->
function take_snapshot() {
 
 // take snapshot and get image data
 Webcam.snap( function(data_uri) {
  // display results in page
  document.getElementById('results').innerHTML = 
  '<img name="photo" src="'+data_uri+'"/>';


  } );


}

</script>
 

                                                   
                                        
                                              <button onclick="this.disabled=true;this.value='Submitting...'; this.form.submit();" class="btn btn-sm btn-info btn-block mt-1" type="submit">{{__('Save')}}</button>
                                          </form>
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
@endsection

