
@extends('admin.master')
@section('title')
Settings | Users Management
@endsection
@section('maincontent')
<div class="container-fluid">
    <ol class="breadcrumb mb-2 mt-2">
            <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
            <li class="breadcrumb-item active">Users Management</li>
        </ol>
        <div>
             @if(auth()->user()->hasPermission('user.create'))
            <a href="{{ route('user.create')}}" type="button" class="btn btn-sm btn-info waves-effect waves-light mb-2"> <i class="fa fa-plus"></i> Add New</a>
             @endif
        <div>
     
     <div class="row">
          <div class="col-lg-12">
            <div class="card">
              <div class="card-header"><i class="fa fa-table"></i> Users Management</div>
              <div class="card-body">
                <div class="table-responsive">
                  <table id="example" class="table table-bordered">

                    <thead>
                     <tr>
                        <th>Sl No</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Store Name</th>
                        <th>Client ID</th>
                        <th>Client Secret</th>
                        <th>Online</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                @foreach($users as $key => $user)
                    <tr>
                        <td>{{ $key + 1}}</td>
                        <td>
                        <div class="widget-content-right flex-2">
                            <div class="widget-heading">{{$user->name}}</div>
                            <div class="widget-subheding opacity-6">
                                @if($user->role)
                                    <span class="badge badge-info">{{ $user->role->name}}</span>
                                        @else
                                        <span class="badge badge-info">No role found</span>
                                        @endif
                            </div>
                        </div>
                        </td>

                        <td>{{ $user->email}}</td>

                        <td>{{ $user->store_name}}</td>
                        <td><input type="password" readonly value="{{ $user->client_id}}"></td>
                        <td><input type="password" readonly value="{{ $user->client_secret}}"></td>
                        <td>
                                    @if($user->isOnline())
                                    <span class="badge badge-success m-1">online</span>
                                    @else
                                    <span class="badge badge-warning m-1">offline</span>
                                    @endif
                                
                        </td>
                        <td>{{ $user->status == 1?'Active':'Inactive'}}</td>
                        <td>
                                    @if(auth()->user()->hasPermission('user.edit'))
                                    <a href="{{route('user.edit', $user->id)}}" class="btn btn-sm btn-info float-left mr-1">
                                        <i class="fa fa-edit"></i>
                                        <span>Edit</span>
                                    </a>
                                    @else
                                    <button type="button" class="btn btn-sm btn-secondary float-left mr-1" disabled><i class="fa fa-edit"></i>
                                        <span>Edit</span></button>

                                    @endif
 
                                    @if($user->role->deletable)
                                        @if(auth()->user()->hasPermission('user.destroy'))
                                       <form id="delete-form-{{ $user->id }}"
                                                action="{{ route('user.destroy',$user->id) }}" method="POST"
                                               >
                                                @csrf()
                                                @method('DELETE')
                                                <button onclick="if (!confirm('Are you sure to delete?')) { return false }" type="submit" class="btn btn-danger btn-sm">
                                                <i class="fas fa-trash-alt"></i>
                                                <span>Delete</span>
                                            </button>
                                            </form>
                                        @else
                                        <button type="button" class="btn btn-sm btn-secondary " disabled><i class="fas fa-trash-alt"></i>
                                            <span>Delete</span></button>
                                        @endif
                                    @else
                                        <button type="button" class="btn btn-sm btn-danger " disabled><i class="fas fa-trash-alt"></i>
                                        <span>Delete</span></button>
                                    @endif
                                </td>
                    </tr>
                    
                @endforeach
                     
                    </tbody>
                    <tfoot>
                        <th>Sl No</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Store Name</th>
                        <th>Client ID</th>
                        <th>Client Secret</th>
                        <th>Online</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tfoot>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
</div>
@endsection
               