@extends('admin.master')
@section('title')
Settings | User
@endsection
@section('maincontent')
<div class="container-fluid">
    <ol class="breadcrumb mb-2 mt-4">
        <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
        <li class="breadcrumb-item"><a href="{{url('user')}}">Users</a></li>
        @isset($user)
          <li class="breadcrumb-item active">Edit User</li>
        @else
          <li class="breadcrumb-item active">Add New User</li>
        @endisset
    </ol>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-5">
                <div class="card shadow-lg border-0 rounded-lg mt-5">
                    <div class="card-body">
                        <form action="{{isset($user) ? route('user.update',$user->id) : route('user.store')}}" method="POST">
                            @csrf
                            @isset($user)
                            @method('PUT')
                            @endisset
                            <div class="form-group">
                                <h4>
                                    @isset($user)
                                    <label class="small mb-0" for="inputEmailAddress">Edit User</label>
                                    @else
                                    <label class="small mb-0" for="inputEmailAddress">Add New User</label>
                                    @endisset
                                </h4>
                                <div class="form-group row">
                            <label for="name" class="col-sm-3 col-form-label">Name</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{isset($user)?$user->name:''}}" id="input-21" placeholder="Enter Your Name" required autofocus>
                                @error('name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror  
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="email" class="col-sm-3 col-form-label">User Name</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control @error('email') is-invalid @enderror" name="email" value="{{isset($user)? $user->email:''}}" id="input-22" placeholder="Enter User Name" required autofocus>
                                @error('email')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="password" class="col-sm-3 col-form-label">Password</label>
                            <div class="col-sm-9">
                                <input type="password" class="form-control @error('password') is-invalid @enderror" id="input-24" name="password" placeholder="Enter Password" {{!isset($user) ?'required':'' }} autofocus>
                                @error('password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="password_confirmation" class="col-sm-3 col-form-label">Confirm Password</label>
                            <div class="col-sm-9">
                                <input type="password" class="form-control @error('password_confirmation') is-invalid @enderror" id="input-25" name="password_confirmation" placeholder="Confirm Password" {{!isset($user) ?'required':'' }} autofocus>
                                @error('password_confirmation')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="store_name" class="col-sm-3 col-form-label">Store Name</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control @error('store_name') is-invalid @enderror" id="input-25" name="store_name" value="{{isset($user)? $user->store_name:''}}" placeholder="Store Name" {{!isset($user) ?'required':'' }} autofocus>
                                @error('store_name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="client_id" class="col-sm-3 col-form-label">Client ID</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control @error('client_id') is-invalid @enderror" id="input-25" name="client_id" value="{{isset($user)? $user->client_id:''}}" placeholder="Client ID" {{!isset($user) ?'required':'' }} autofocus>
                                @error('client_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                        </div>



                        <div class="form-group row">
                            <label for="client_secret" class="col-sm-3 col-form-label">Client Secret</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control @error('client_secret') is-invalid @enderror" id="input-25" name="client_secret" value="{{isset($user)? $user->client_secret:''}}" placeholder="Client Secret" {{!isset($user) ?'required':'' }} autofocus>
                                @error('client_secret')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                        </div>


                        <div class="form-group row">
                        <label for="input-1" class="col-sm-3 col-form-label">Select Role</label>
                        <div class="col-sm-9">
                            <select class="js-example-basic-single form-control @error('role_id') is-invalid @enderror" name="role_id" required autofocus>
                            <option value="">Select Role</option>
                            @foreach($roles as $role)
                            <option value="{{ $role->id}}" @isset($user) {{ $role->id == $user->role_id ?'selected' :'' }}@endisset style="color:black;">{{$role->name}}</option>
                            @endforeach
                        </select>
                        @error('role_id')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                        </div>
                        
                       </div>

                        <div class="form-group row">
                            <label for="password_confirmation" class="col-sm-3 col-form-label"></label>
                            <div class="col-sm-9">
                               <div class="custom-control custom-switch">
                            <input type="checkbox" class="custom-control-input" value="1" name="status" @isset($user){{ $user->status == 1?'checked':''}}@endisset id="customSwitch1" >
                            <label class="custom-control-label" for="customSwitch1">Status</label>
                            </div>
                            </div>
                        </div>


                    <div class="form-group row">
                        <label class="col-sm-3 col-form-label"></label>
                        <div class="col-sm-9">
                            @isset($user)
                                <button type="submit" class="btn btn-sm btn-info px-5 btn-block"><i class="icon-lock"></i> User Update</button>
                            @else
                                <button type="submit" class="btn btn-sm btn-info px-5 btn-block"><i class="icon-lock"></i> User Create</button>
                            @endisset
                            
                        </div>
                    </div>

                                
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection