
@extends('admin.master')
@section('title')
Settings | Permissions 
@endsection
@section('maincontent')
<div class="container-fluid">
    <ol class="breadcrumb mb-2 mt-2">
            <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
            <li class="breadcrumb-item active">Permissions Management</li>
        </ol>
        <div>
            <a href="{{ route('role.create')}}" type="button" class="btn btn-sm btn-info waves-effect waves-light mb-2"> <i class="fa fa-plus"></i> Add New</a>
        <div>
     
     <div class="row">
          <div class="col-lg-12">
            <div class="card">
              <div class="card-header"><i class="fa fa-table"></i> Permissions Management</div>
              <div class="card-body">
                <div class="table-responsive">
                  <table id="example" class="table table-bordered">
                    <thead>
                     <tr>
                        <th>Sl No</th>
                        <th>Roles Name</th>
                        <th>Permissions</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                        @php($sl=1)
                        @foreach($roles as $key => $role)
                            <tr>
                                <td>{{$key+1}}</td>
                                <td>{{$role->name}}</td>
                                <td>
                                  @if($role->permissions->count() > 0)
                                        <span class="badge badge-success m-1">{{$role->permissions->count() }}</span>
                                    @else
                                        <span class="badge badge-success m-1">No Permission found :) </span>
                                    @endif
                                </td>
                                <td>
                                   @if(auth()->user()->hasPermission('role.edit'))
                                    <a href="{{route('role.edit', $role->id)}}" class="btn btn-sm btn-info float-left mr-1">
                                        <i class="fa fa-edit"></i>
                                        <span>Edit</span>
                                    </a>
                                @else
                                <button type="button" class="btn btn-sm btn-info float-left mr-1" disabled><i class="fa fa-edit"></i>
                                            <span>Edit</span></button>
                                      
                                @endif

                                    @if($role->deletable)
                                        @if(auth()->user()->hasPermission('role.destroy'))
                                            <form id="delete-form-{{ $role->id }}"
                                                action="{{ route('role.destroy',$role->id) }}" method="POST"
                                               >
                                                @csrf()
                                                @method('DELETE')
                                                <button onclick="if (!confirm('Are you sure to delete?')) { return false }" type="submit" class="btn btn-danger btn-sm">
                                                <i class="fas fa-trash-alt"></i>
                                                <span>Delete</span>
                                            </button>
                                            </form>
                                        @else
                                            <button type="button" class="btn btn-sm btn-secondary " disabled><i class="fas fa-trash-alt"></i>
                                            <span>Delete</span></button>
                                        @endif
                                @else
                                        <button type="button" class="btn btn-sm btn-danger " disabled><i class="fas fa-trash-alt"></i>
                                            <span>Delete</span></button>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                          <th>Sl No</th>
                          <th>Roles Name</th>
                          <th>Permissions</th>
                          <th>Action</th>
                        </tr>
                    </tfoot>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
</div>
@endsection
               