@extends('admin.master')
@section('title')
Settings | Department 
@endsection
@section('maincontent')
<div class="container-fluid">
<div class="row mt-2">
    <div class="col-lg-12">
        <form action="{{isset($role) ? route('role.update',$role->id) : route('role.store')}}" method="post">
            @csrf
            @isset($role)
            @method('PUT')
            @endisset
            <div class="card" style="box-shadow: rgb(14, 11, 11);">
                <div class="card-body">
                    <a href="{{route('role.index')}}" class="btn btn-sm btn-dark pull-right mt-0 mb-2 "><i class="fa fa-arrow-circle-left"></i>  Back</a>
                    <div class="form-group">
                        <label for="name" style="font-weight: bold;">Role Name</label>
                        <input type="text" class=" col-md-3 form-control @error('name') is-invalid @enderror" name="name" value="{{ $role->name ?? old('name') }}" required autofocus>

                        @error('name')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>

                    <div class="card-title text-center">
                        @error('permissions')
                            <p>
                                <span class="text-danger" role="alert">
                                 <strong>{{ $message }}</strong>
                                </span>
                            </p>
                            
                        @enderror
                    </div>
                        
                    <div class="form-group">
                        <input type="checkbox" id="select-all">
                        <label for="select-all">Select All</label>
                    </div>
                    @forelse($modules->chunk(2) as $key => $chunk)
                    <div class="form-row">
                        @foreach($chunk as $key => $module)
                        <div class="col-md-3">
                            <h5>{{$module->name}} </h5>
                            @foreach($module->permissions as $permission)
                            <div class="md-3 lg-3">
                                <div class="custome-control custome-checkbox md-3">
                                    <input type="checkbox" class="custome-control-input" id="permission-{{$permission->id}}" name="permissions[]" value="{{$permission->id}}" 
                                     @isset($role)
                                        @foreach($role->permissions as $rPermission)
                                            {{$permission->id == $rPermission->id? "checked":""}}
                                        	@endforeach
                                     		@endisset>
                                    <label for="permissions-{{$permission->id}}">
                                            {{$permission->name}}</label>
                                </div>
                            </div>
                            @endforeach
                        </div>
                        @endforeach
                    </div>
                    @empty
                    <div class="row">
                        <div class="col text-center">
                            <strong>No Module Found</strong>
                        </div>
                    </div>
                    @endforelse
                    
                </div>
                @isset($role)
                <button onclick="this.disabled=true;this.value='Submitting...'; this.form.submit();" class="btn btn-sm btn-info">
                <i class="fa fa-arrow-circle-up"></i>    
                Update Role</button>
                @else
                <button onclick="this.disabled=true;this.value='Submitting...'; this.form.submit();" class="btn btn-sm btn-info">
                <i class="fa fa-plus"></i>    
                Create Role</button>
                @endisset
            <div>

        </form>
    </div>
</div>
</div>

@endsection

@section('custom_js')
<script>
    $('#select-all').click(function() {
        if(this.checked) {
            $(":checkbox").each(function(){
                this.checked = true;
            })
        }else{
            $(":checkbox").each(function(){
                this.checked = false;
            })
        }
    });
</script>
@endsection