@extends('admin.master')
@section('title')
Reports | Salary Summary
@endsection
@section('maincontent')
	<div class="pt-5">
		<div class="col-sm-12 d-flex justify-content-center">
              <div class="panel col-sm-6">
                   <div class="panel-heading" style="background-color: #09A9A1">
                       <div class="text-center" style="color:#fff; font-weight:bold">Salary Information View / Print</div>
                     </div>
                     	 <div class="panel-body">
                             <div class="form"  style="min-height:100px;">
                           <form action="{{url('reports/salary_summary_report')}}" method="post">
                           	@csrf
                             <table border="0" width="100%" style="color:#000">
                               <tr>
                                <td width="100px" style="padding:2px 3px; border-bottom:1px solid #999">Company</td>
                                     <td width="5px" style="border-bottom:1px solid #999">:</td>
                                    <td style="padding:2px 5px; border-bottom:1px solid #999">
                                    	<select class="input-control" name="unit_id" id="unitId">
                                            $@foreach ($units as $unit)
                                                 <option value="{{$unit->id}}">{{$unit->unit_name}}</option>
                                            @endforeach
                                    	</select>
                                    </td>
                                </tr>
                                <tr>
                                	<td width="100px" style="padding:2px 3px; border-bottom:1px solid #999">Department</td>
                                    <td width="5px" style="border-bottom:1px solid #999">:</td>
                                    <td style="padding:2px 5px; border-bottom:1px solid #999">
                                    	<select class="input-control" name="department_id" id="departmentId">
                                             <option value="420">All Department</option>
                                    		@foreach ($departments as $department)
                                                 <option value="{{$department->id}}">{{$department->department_name}}</option>
                                            @endforeach
                                    	</select>
                                    </td>
                                </tr>

                                <tr>
                                	<td colspan="3" class="text-center pt-2 pb-2" style="padding:2px 3px; border-bottom:1px solid #999">
                                		  <select id="year_night" name="salary_year"></select>
                        				  <select id="month_night" name="salary_month"></select>
                                	</td>
                                </tr>

                                 <tr>
                                	<td colspan="3" class="text-center" style="padding:2px 3px; border-bottom:1px solid #999">
                                		 <button class="btn btn-info" type="submit">Report</button>
                                	</td>
                                </tr>
                            </table>
                        </form>
                      
                    </div>
                </div>
            </div>
	</div>
 
@endsection
@section('custom_js')
<script>
  $(document).ready(function () {
//change selectboxes to selectize mode to be searchable
  $("#departmentId,#unitId").select2();
});
</script>
@endsection