@extends('admin.master')
@section('title', 'Report Sync')

@section('maincontent')
<div class="container-fluid">
    <div class="card mb-2 mt-4 p-2">
        <section id="main-content" style="margin: auto;">
            <div class="form-row show-inputbtns" align="center">
                <form id="syncForm">
                    @csrf
                    <input name="createdStartDate" type="date" id="createdStartDate" required /> To
                    <input name="createdEndDate" type="date" id="createdEndDate" required />
                    <button type="button" id="startSync" class="btn btn-sm btn-dark">Start Sync</button>
                </form>
            </div>
            <div class="progress mt-4" style="height: 30px;">
                <div id="progressBar" class="progress-bar" role="progressbar" style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">0%</div>
            </div>
        </section>
    </div>
</div>

<script>
    document.getElementById('startSync').addEventListener('click', function() {
        const createdStartDateInput = new Date(document.getElementById('createdStartDate').value);
        let createdEndDate = new Date(document.getElementById('createdEndDate').value);
        const progressBar = document.getElementById('progressBar');

        // Calculate total days for progress bar calculation
        const totalDays = Math.floor((createdEndDate - createdStartDateInput) / (1000 * 60 * 60 * 24));

        function updateProgressBar() {
            const remainingDays = Math.floor((createdEndDate - createdStartDateInput) / (1000 * 60 * 60 * 24));
            const progress = ((totalDays - remainingDays) / totalDays) * 100;
            progressBar.style.width = `${progress}%`;
            progressBar.innerHTML = `${Math.round(progress)}%`;
        }

        function callReport() {
             createdEndDate.setDate(createdEndDate.getDate() - 5); 
              updateProgressBar();
            if (createdEndDate <= createdStartDateInput) {
                clearInterval(interval);
                progressBar.innerHTML = 'Completed';
                return;
            }

            fetch(`/syncorder?createdStartDate=${createdStartDateInput.toISOString().split('T')[0]}&createdEndDate=${createdEndDate.toISOString().split('T')[0]}`)
                .then(response => {
                    if (response.ok) {
                        return response.json();
                    } else {
                        throw new Error('Network response was not ok.');
                    }
                })
                .then(data => {
                    console.log(data);
                   // Decrease by 5 days
                    updateProgressBar();
                })
                .catch(error => console.error('Error:', error));
        }

       
        const interval = setInterval(callReport, 15000);
    });
</script>
@endsection
