
@extends('admin.master')
@section('title')
Dashboard | WFS Orders 
@endsection
@section('maincontent')
<div class="container-fluid">
    <ol class="breadcrumb mb-2 mt-4">
            <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
            <li class="breadcrumb-item active">Order Management</li>
        </ol>
      
     
     <div class="row">
          <div class="col-lg-12">
            <div class="card">
              <div class="card-header"><i class="fa fa-table"></i> WFS orders</div>
              <div class="card-body">
                <div class="table-responsive">
                  <table id="example" class="table table-bordered">
                    <thead>
                     <tr>
                        <th>Sl No</th>
                        <th>Order Date</th>
                        <th>Purchase Order#</th>
                        <th>Customer Name</th>
                        <th>Product Name</th>
                        <th>Buy Qty</th>
                        <th>Price</th>
                        <th>Image</th>
                        <th>Sku</th>
                        <th>Ship Date</th>
                        <th>Status</th>
                       
                    </tr>
                    </thead>
                    <tbody>
                    @if(!empty($response))
                     @foreach ($response['list']['elements'] as $item => $value)

                     @php
                     $sl = 1;
                       for($i = 0; $i < count($value); $i++) {
                       
                        $orderDateTime = $value[$i]['orderDate'];
                        $shipDateTime = $value[$i]['shippingInfo']['estimatedShipDate'];
                        $orderDate =  date('Y-m-d',$orderDateTime/1000);
                        $shipDate =  date('Y-m-d',$shipDateTime/1000);

                        $sold_qty = 0;

                            if (isset($value[$i]['orderLines']['orderLine'])) {
                           
                                foreach ($value[$i]['orderLines']['orderLine'] as $orderLine) {
                                    if (isset($orderLine['orderLineQuantity']['amount'])) {
                                        $sold_qty += intval($orderLine['orderLineQuantity']['amount']);
                                    }
                                }
                            }





                        $chargeAmount = $value[$i]['orderLines']['orderLine'][0]['charges']['charge'][0]['chargeAmount']['amount'];

                        $cAmount = $chargeAmount * $sold_qty;
                        @$name = $value[$i]['shippingInfo']['postalAddress']['name'];
                     
                     
                           echo "<tr>
                            <td>{$sl}</td>
                            <td>{$orderDate}</td>
                            <td>{$value[$i]['purchaseOrderId']}</td>
                            <td>{$name}</td>
                            <td>{$value[$i]['orderLines']['orderLine'][0]['item']['productName']}</td>
                            <td>{$sold_qty}</td>
                            <td>{$cAmount}</td>
                            <td><img src='{$value[$i]['orderLines']['orderLine'][0]['item']['imageUrl']}' height=30 width=30 ></img></td>
                            <td>{$value[$i]['orderLines']['orderLine'][0]['item']['sku']}</td>
                            <td>{$shipDate}</td>
                            <td>{$value[$i]['orderLines']['orderLine'][0]['orderLineStatuses']['orderLineStatus'][0]['status']}</td>
                            </tr>";
                            $sl++;
                        }
                       
                     @endphp
                     @endforeach    
                     @endif
                    </tbody>
                   
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
</div>
@endsection
               