
@extends('admin.master')
@section('title')
Dashboard | WFS Inventory Performance
@endsection
@section('maincontent')
<div class="container-fluid">
    <ol class="breadcrumb mb-2 mt-4">
            <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
            <li class="breadcrumb-item active">Inventory Management</li>
        </ol>
      
     
     <div class="row">
          <div class="col-lg-12">
            <div class="card">
              <div class="card-header"><i class="fa fa-table"></i> WFS inventory report</div>
              <div class="card-body">
                <div class="table-responsive">
                  <table id="example" class="table table-bordered">
                    <thead>
                     <tr>
                        <th>Sl No</th>
                        <th>Item SKU</th>
                        <th>UPC</th>
                        <th>Item Name</th>
                        <th>Image</th>
                        <th>Avail Sell Qty</th>
                        <th>Suplier</th>
                        <th>7 Days Sales</th>
                        <th>14 Days Sales</th>
                        <th>30 Days Sales</th>
                         <th>Life Time Sales</th>
                        
                       
                    </tr>
                    </thead>
                    <tbody>
                      @if (!empty($result))
                          
                   @php 
                       $sl = 1;
                   @endphp
                     @foreach ($result as $value)

                     <tr>
                      <td style="text-align: center">{{$sl++}}</td>
                       <td>{{$value['item_sku']}}</td>
                       
                       <td>
                           {{preg_replace('/[a-zA-Z.\-]/', '', $value['item_sku']);}}
                         
                       </td>
                       
    

                       <td>{{$value['item_name']}}</td>
                       <td><img src='{{$value['item_image_url']}}' height=30 width=30 ></img></td>

                       @if ($value['avai_sell_qty'] <=10)
                       <td  style="text-align: center;color:red">{{$value['avai_sell_qty']}}</td>
                       @else 
                       <td  style="text-align: center">{{$value['avai_sell_qty']}}</td>
                       @endif
                       
                       <!--@if ($value['item_qty'] == 0)-->
                       <!--<td  style="text-align: center;color:red">{{$value['item_qty']}}</td>-->
                       <!--@elseif ($value['item_qty'] == 1)-->
                       <!-- <td  style="text-align: center;color:red">{{$value['item_qty']-1}}</td>-->
                       <!--@else -->
                       <!--<td  style="text-align: center">{{$value['item_qty']}}</td>-->
                       <!--@endif-->

                      

                       <td style="text-align: center">{{$value['suplier_name']}}</td>
                     
                  
                      @if (!empty($value['last7daysqty']))
                      <td style="text-align: center">{{$value['last7daysqty']}}</td>
                      @else
                      <td  style="text-align: center">{{'0'}}</td>
                      @endif
                     
                      @if (!empty($value['last14daysqty']))
                      <td style="text-align: center">{{$value['last14daysqty']}}</td>
                      @else
                      <td  style="text-align: center">{{'0'}}</td>
                      @endif

                      @if (!empty($value['last30daysqty']))
                      <td style="text-align: center">{{$value['last30daysqty']}}</td>
                      @else
                      <td  style="text-align: center">{{'0'}}</td>
                      @endif
                      
                      @if (!empty($value['lifetimesell']))
                      <td style="text-align: center">{{$value['lifetimesell']}}</td>
                      @else
                      <td  style="text-align: center">{{'0'}}</td>
                      @endif
                      
                      
                       <!--@if ($value['item_qty'] == 1)-->
                       <!-- <td  style="text-align: center;">{{($value['item_qty']-1)-($value['lifetimesell']+$value['avai_sell_qty'])}}</td>-->
                       <!--@else -->
                       <!--<td  style="text-align: center;">{{($value['item_qty'])-($value['lifetimesell']+$value['avai_sell_qty'])}}</td>-->
                       <!--@endif-->
                      
                      
                
                     
                      
                     </tr>
                     @endforeach   
                     
                     
                     @endif
                    </tbody> 
                    
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
</div>
@endsection
               