
@extends('admin.master')
@section('title')
Dashboard | Upload Report
@endsection
  <style>
        /* Add your CSS styles for the preloader here */
        #preloader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.9);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 9999;
        }

        #loader {
            border: 4px solid #3498db;
            border-top: 4px solid #e74c3c;
            border-radius: 50%;
            width: 50px;
            height: 50px;
            animation: spin 2s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
@section('maincontent')

<div class="container-fluid">
    <ol class="breadcrumb mb-2 mt-4">
            <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
            <li class="breadcrumb-item active">BuyBox Management</li>
        </ol>
        <div class="container col-sm-6">    
            <br />
            <div id="preloader">
  <div id="loader"></div>
</div>
            <div class="panel panel-default">
                       <div class="panel-heading">
                           <h4 >Upload Report file</h4>
                       </div>
                       <div class="panel-body pt-2 pb-5">
                           <br />
                           <form  method="post" action="{{ url('/import/buyboxReport') }}" enctype="multipart/form-data">
                             @csrf
                             <div class="row">
                                   <div class="col-md-3" align="right"><h4>Select File</h4></div>
                                   <div class="col-md-6">
                                     <input type="file" name="select_file" class="file-input @error('select_file') is-invalid @enderror" id="file" />
                                     <input type="submit"  name="upload" class="btn btn-primary " value="Upload">
                               </div>
                               <section class="progress-area"></section>
                               <section class="uploaded-area"></section>
                           </form>
                           <br />
                           <br />
                    </div>
            </div>
        @if (session('success'))
            <div class="mt-2 d-flex justify-content-center">
                <a href="{{url('buybox/automate')}}" class="btn btn-info" id="loadButton" >Click To Check Buybox With AI</a>
            </div>
        @endif

                   
</div> 
</div>

@endsection
@section('custom_js')
<script>
        $(document).ready(function() {
            // Hide the preloader initially
            $('#preloader').hide();

            // Add a click event handler to the loadButton
            $('#loadButton').click(function() {
                // Show the preloader when the button is clicked
                $('#preloader').show();

                // Add a delay to simulate some loading time (you can remove this in production)
                
                window.onload = function () {
                    document.getElementById('preloader').style.display = 'none';
                };
    
               // Adjust the delay time as needed
            });

            // Hide the preloader when the entire page is loaded
            $(window).on('load', function() {
                $('#preloader').hide();
            });
        });
    </script>

@endsection

               