<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;
use App\Models\Module;
class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     * 
     * @return void
     */
    public function run()
    {
        $moduleAppDashboard = Module::updateOrCreate([
            'name' => 'Admin Dasboard'
        ]);

        $moduleSidebar = Module::updateOrCreate([
            'name' => 'Module Management'
        ]); 

         Permission::updateOrCreate([
            'module_id' => $moduleSidebar->id,
            'name' => 'Order Management',
            'slug' => 'sidebar.order_management'
        ]);

         Permission::updateOrCreate([
            'module_id' => $moduleSidebar->id,
            'name' => 'Purchasing',
            'slug' => 'sidebar.purchasing'
        ]);

         Permission::updateOrCreate([
            'module_id' => $moduleSidebar->id,
            'name' => 'Shipments',
            'slug' => 'sidebar.shipments'
        ]);

         Permission::updateOrCreate([
            'module_id' => $moduleSidebar->id,
            'name' => 'Inventory',
            'slug' => 'sidebar.inventory'
        ]);
         Permission::updateOrCreate([
            'module_id' => $moduleSidebar->id,
            'name' => 'Settings',
            'slug' => 'sidebar.settings'
        ]);

        Permission::updateOrCreate([
            'module_id' => $moduleAppDashboard->id,
            'name' => 'Access Dashboard',
            'slug' => 'dashboard'
        ]);

        $moduleVisitor = Module::updateOrCreate([
            'name' => 'Order Management'
        ]);

        Permission::updateOrCreate([
            'module_id' => $moduleVisitor->id,
            'name' => 'Orders',
            'slug' => 'orders.view'
        ]);
        Permission::updateOrCreate([
            'module_id' => $moduleVisitor->id,
            'name' => 'Profit Report',
            'slug' => 'orders.report'
        ]);
        

        $moduleAppUser = Module::updateOrCreate([
            'name' => 'Purchasing'
        ]);

        Permission::updateOrCreate([
            'module_id' => $moduleAppUser->id,
            'name' => 'Purchasing Report',
            'slug' => 'purchasing.report'
        ]);
        Permission::updateOrCreate([
            'module_id' => $moduleAppUser->id,
            'name' => 'Add New Purchase',
            'slug' => 'purchasing.add_new'
        ]);
       
        $moduleAppRole = Module::updateOrCreate([
            'name' => 'Shipments'
        ]);

        Permission::updateOrCreate([
            'module_id' => $moduleAppRole->id,
            'name' => 'Shipments Report',
            'slug' => 'shipment.report'
        ]);

        $moduleAppRole = Module::updateOrCreate([
            'name' => 'Inventory'
        ]);

        Permission::updateOrCreate([
            'module_id' => $moduleAppRole->id,
            'name' => 'Inventory Report',
            'slug' => 'inventory.report'
        ]);


 	$moduleAppUser = Module::updateOrCreate([
            'name' => 'User Management'
        ]);

        Permission::updateOrCreate([
            'module_id' => $moduleAppUser->id,
            'name' => 'Access User',
            'slug' => 'user.index'
        ]);
        Permission::updateOrCreate([
            'module_id' => $moduleAppUser->id,
            'name' => 'Create User',
            'slug' => 'user.create'
        ]);
        Permission::updateOrCreate([
            'module_id' => $moduleAppUser->id,
            'name' => 'Edit User',
            'slug' => 'user.edit'
        ]);
        Permission::updateOrCreate([
            'module_id' => $moduleAppUser->id,
            'name' => 'Delete User',
            'slug' => 'user.destroy'
        ]);
       

        $moduleAppRole = Module::updateOrCreate([
            'name' => 'Role Management'
        ]);

        Permission::updateOrCreate([
            'module_id' => $moduleAppRole->id,
            'name' => 'Access Role',
            'slug' => 'role.index'
        ]);
        Permission::updateOrCreate([
            'module_id' => $moduleAppRole->id,
            'name' => 'Create Role',
            'slug' => 'role.create'
        ]);
        Permission::updateOrCreate([
            'module_id' => $moduleAppRole->id,
            'name' => 'Edit Role',
            'slug' => 'role.edit'
        ]);
        Permission::updateOrCreate([
            'module_id' => $moduleAppRole->id,
            'name' => 'Delete Role',
            'slug' => 'role.destroy'
        ]);


         
    }
 
}