<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateShipsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ships', function (Blueprint $table) {
            $table->id();
            $table->string('inboundOrderId')->nullable();
            $table->string('shipmentId')->nullable();
            $table->string('gtin')->nullable();
            $table->string('sku')->nullable();
            $table->string('itemDesc')->nullable();
            $table->string('itemQty')->nullable();
            $table->string('expectedDeliveryDate')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ships');
    }
}
