<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->id();
            $table->string('employee_name');
            $table->string('join_date');
            $table->string('id_card_no');
            $table->string('employee_type')->nullable();
            $table->string('gender')->nullable();
            $table->string('ret_date')->nullable();
            $table->string('father_name')->nullable();
            $table->string('mother_name')->nullable();
            $table->string('merital_status')->nullable();
            $table->string('date_of_birth')->nullable();
            $table->string('nation')->nullable();
            $table->string('religion')->nullable();
            $table->string('nid_or_dob')->nullable();
            $table->string('unit');
            $table->string('designation');
            $table->string('department');
            $table->string('duty_from');
            $table->string('duty_to');
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->string('back_account_no')->nullable();
            $table->string('present_address')->nullable();
            $table->string('permanent_address')->nullable();
            $table->string('remarks')->nullable();
            $table->string('employee_photo')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employees');
    }
}
