<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Visitor;
use Illuminate\Support\Facades\Gate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;

class VisitorController extends Controller
{
    public function index(){
        $visitors = Visitor::orderBy('id','DESC')->get();
        return view('admin.visitor.index')->with('visitors',$visitors);
    }

    public function visitorSave(Request $request){
        $inTime = date('H:i:s');
        $date = date('Y-m-d');

       $input['visitor_photo'] = null;
       if ($request->hasFile('visitor_photo')) {
            $file       =$request->file('visitor_photo');
            $fileType   =$file->getClientOriginalExtension();
            $fileName   ="v_".rand(1,1000).date('dmyhis').".".$fileType;
            $file->move('visitors/photos',$fileName);
            $input['visitor_photo']=$fileName;
        }

       
        DB::table('visitors')
            ->insert([
            'card_no' => $request->card_no, 
            'visitor_name' => $request->visitor_name,
            'vehicle_no' => $request->vehicle_no,
            'description' => $request->description,
            'visitor_photo' =>  $input['visitor_photo'],
            'visit_date' => $date,
            'in_time' => $inTime
        ]);
        return redirect('visitor/index')->with('success','Visitor Add Successfully');
       
    }
    public function outTime($visitorId){
        $visitors = Visitor::find($visitorId);
        if($visitors->out_time){
            return redirect('visitor/index')->with('error','Out time Already Exist');
        }
        else{
            $outTime = date('H:i:s');
            $outDate = date('Y-m-d');

            DB::table('visitors')
            ->where('id', $visitorId)
            ->update([
                'out_date' => $outDate,
                'out_time' => $outTime
                ]);
            return redirect('visitor/index')->with('success','Out time Added');
        }

      
    }

    public function visitorEdit($visitorId){
        Gate::authorize('visitor.edit');
        $id = \Crypt::decrypt($visitorId);
        $visitors = Visitor::find($id);
        foreach($visitors as $visitor){

        }
        return view('admin.visitor.edit')->with('visitor',$visitor);
    }

    public function visitorUpdate(Request $request){
        DB::table('visitors')
            ->where(['id'=> $request->id])
            ->update([
                'card_no' => $request->card_no,
                'visitor_name' => $request->visitor_name,
                'vehicle_no' => $request->vehicle_no,
                'description' => $request->description,
                'visit_date' => $request->visit_date,
                'out_date' => $request->out_date,
                'in_time' => $request->in_time,
                'out_time' => $request->out_time
                ]);
            return redirect('visitor/index')->with('success','Update Successfully');
        
    }

    public function visitorDelete($visitorId){
        Gate::authorize('visitor.destroy');
        $visitor = Visitor::find($visitorId);
        $visitor->delete();
        return redirect('visitor/index')->with('error','Delete Successfully');
    }

    public function visitorReportBy(){
        Gate::authorize('visitor.reports');
        return view('admin.visitor.report_by');
    }

    public function visitorReports(Request $request){
        
        Gate::authorize('visitor.reports');
        $visitorsReport = Visitor::whereBetween('visit_date',[$request->from_date,$request->to_date])->get();
        if($visitorsReport->isEmpty()){
            return redirect('visitor/report_by')->with('error','Data not Found');
        }else{
            return view('admin.visitor.reports')
            ->with('visitorsReport',$visitorsReport)
            ->with('reportDate',$request);            
        }
        
    }
}
