<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Employee;
use App\Models\Salary;
use Illuminate\Http\Request;
use DB;

class SalaryController extends Controller
{
    public function addSalary(Request $request){
        // $employees = DB::table('employees')
        // ->join('designations','designations.id','=','employees.designation')
        // ->join('salaries','salaries.employee_id','=','employees.id_card_no')
        // ->where(['employees.id_card_no'=>$request->employeeId])
        // ->select('employees.*','designations.designation_name','salaries.*')->get();
        $employees = DB::table('employees')
        ->join('designations','designations.id','=','employees.designation')
        ->where(['employees.id_card_no'=>$request->employeeId])
        ->select('employees.*','designations.designation_name')->get();

        $salaries = DB::table('salaries')
                    ->where(['salaries.employee_id'=>$request->employeeId])
                    ->select('salaries.*')->get();
      
        if($employees->isEmpty()){
            return view('admin.salary.add_salary');
        }else{
            return view('admin.salary.add_salary')
            ->with('employees', $employees)
            ->with('salaries',$salaries);
           
        }
    	
    }

    public function saveSalary(Request $request){
        $row = DB::table('salaries')
        ->where(['salaries.employee_id'=>$request->employee_id])
        ->get();
        if ($row->isEmpty()) {
            $data = request()->except(['_token']);
            $row = DB::table('salaries')->insert($data);
            return redirect('salary/add_salary')->with('success','Salary Add Successfully!!');
        } else {
            DB::table('salaries')
            ->where(['salaries.employee_id'=>$request->employee_id])
            ->update([
                'employee_id'       => $request->employee_id,
                'fund_amount'       => $request->fund_amount,
                'stamp_amount'      => $request->stamp_amount,
                'apron_amount'      => $request->apron_amount,
                'others_amount'     => $request->others_amount,
                'deduction_total'   => $request->deduction_total,
                'basic_remarks'     => $request->basic_remarks,
                'c_others_amount'   => $request->c_others_amount,
                'c_others_remarks'  => $request->c_others_remarks,
                'con_amount'        => $request->con_amount,
                'con_remarks'       => $request->con_remarks,
                'addittion_total'   => $request->addittion_total,
                'total_net_amount'  => $request->total_net_amount
                ]);
                return redirect('salary/add_salary')->with('success','Update Successfully!!');
        }
        
    }
}
