<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Absent;
use App\Models\Department;
use App\Models\Designation;
use App\Models\Employee;
use App\Models\Leave;
use App\Models\Night; 
use App\Models\Offday;
use App\Models\Unit;
use DateTime;
use Illuminate\Http\Request;
use DB;

class ReportController extends Controller
{
    public function salarySheet(){
         $units = Unit::all();
         $departments = Department::all();

        return view('admin.reports.salary_sheet.salary_sheet')
        ->with('units',$units)
        ->with('departments',$departments);
    }

    public function salaryReport(Request $request){


        $unit           = Unit::find($request->unit_id);
        $department     = Department::find($request->department_id);  
        
        $monthNum       = $request->salary_month +1;
        $dateObj        = DateTime::createFromFormat('!m', $monthNum);
        $monthName      = $dateObj->format('F');
        $salaryDate     = $monthName."-".$request->salary_year;

        if($request->department_id == "420"){
            $department     = Department::all();
            $employees = DB::table('employees')
            ->leftjoin('salaries','salaries.employee_id','=','employees.id_card_no') 
            ->leftjoin('nights','nights.employees_id','=','salaries.employee_id')
            ->leftjoin('absents','absents.employee_id','=','salaries.employee_id')
            ->leftjoin('offdays','offdays.employee_id','=','salaries.employee_id')
            ->leftjoin('leaves','leaves.employee_id','=','salaries.employee_id')
            ->leftjoin('departments','departments.id','=','employees.department')
            ->leftjoin('designations','designations.id','=','employees.designation')
            ->where(
                ['employees.unit'=>$request->unit_id,
                'nights.salary_month'=>$request->salary_month,
                'nights.salary_year'=>$request->salary_year,
                'absents.salary_month'=>$request->salary_month,
                'absents.salary_year'=>$request->salary_year,
                'offdays.salary_month'=>$request->salary_month,
                'offdays.salary_year'=>$request->salary_year,
                'leaves.salary_month'=>$request->salary_month,
                'leaves.salary_year'=>$request->salary_year
                ]
                )
            ->select('employees.*','nights.*','salaries.*','absents.abs_total_days','offdays.off_total_days','leaves.leave_total_days','departments.department_name','designations.designation_name')
            ->orderBy('designations.designation_name')
            ->get();
            return view('admin.reports.salary_sheet.salary_report_full')
                    ->with('employees',$employees)
                    ->with('unit',$unit)
                    ->with('department',$department)
                    ->with('salaryDate',$salaryDate);
        }else{
        $employees = DB::table('employees')
        ->leftjoin('salaries','salaries.employee_id','=','employees.id_card_no') 
        ->leftjoin('nights','nights.employees_id','=','salaries.employee_id')
        ->leftjoin('absents','absents.employee_id','=','salaries.employee_id')
        ->leftjoin('offdays','offdays.employee_id','=','salaries.employee_id')
        ->leftjoin('leaves','leaves.employee_id','=','salaries.employee_id')
        ->leftjoin('departments','departments.id','=','employees.department')
        ->leftjoin('designations','designations.id','=','employees.designation')
        ->where(
            ['employees.unit'=>$request->unit_id,
            'employees.department'=>$request->department_id,
            'nights.salary_month'=>$request->salary_month,
            'nights.salary_year'=>$request->salary_year,
            'absents.salary_month'=>$request->salary_month,
            'absents.salary_year'=>$request->salary_year,
            'offdays.salary_month'=>$request->salary_month,
            'offdays.salary_year'=>$request->salary_year,
            'leaves.salary_month'=>$request->salary_month,
            'leaves.salary_year'=>$request->salary_year
            ]
            )
        ->select('employees.*','nights.*','salaries.*','absents.abs_total_days','offdays.off_total_days','leaves.leave_total_days','departments.department_name','designations.designation_name')
        ->orderBy('designations.designation_name')
        ->get();


        return view('admin.reports.salary_sheet.salary_report')
                ->with('employees',$employees)
                ->with('unit',$unit)
                ->with('department',$department)
                ->with('salaryDate',$salaryDate);
        }
    }


    public function gen(){
        return view('admin.settings.add_salary.gen_salary');
    }

    public function genarate(Request $request){
        try {
            $employees = Employee::all();
        
            foreach($employees as $emp){
                Offday::updateOrCreate([
                    'employee_id'  => $emp->id_card_no,
                    'salary_month' => $request->salary_month,
                    'salary_year'  => $request->salary_year
                ]
                   
                )->save();

                Leave::updateOrCreate([
                    'employee_id'  => $emp->id_card_no,
                    'salary_month' => $request->salary_month,
                    'salary_year'  => $request->salary_year
                ]
                   
                )->save();

                Absent::updateOrCreate([
                    'employee_id'  => $emp->id_card_no,
                    'salary_month' => $request->salary_month,
                    'salary_year'  => $request->salary_year
                ]
                   
                )->save();

                Night::updateOrCreate([
                    'employees_id'  => $emp->id_card_no,
                    'salary_month' => $request->salary_month,
                    'salary_year'  => $request->salary_year
                ]
                   
                )->save();
               }
               return redirect()->back()->with('success','Salary Generate Successfully');
        } catch (\Throwable $th) {
            return redirect()->back()->with('error','Data Not Found');
        }
       
    }


    public function paySlip(){
         $units = Unit::all();
         $departments = Department::all();

        return view('admin.reports.pay_slip.pay_slip')
        ->with('units',$units)
        ->with('departments',$departments);
    }

    public function paySlipReport(Request $request){
        $unit           = Unit::find($request->unit_id);
        $department     = Department::find($request->department_id);
        
        $monthNum       = $request->salary_month +1;
        $dateObj        = DateTime::createFromFormat('!m', $monthNum);
        $monthName      = $dateObj->format('F');
        $salaryDate     = $monthName."-".$request->salary_year;

        if($request->department_id == "420"){

            $department     = Department::all();
            $employees = DB::table('employees')
            ->leftjoin('salaries','salaries.employee_id','=','employees.id_card_no') 
            ->leftjoin('nights','nights.employees_id','=','salaries.employee_id')
            ->leftjoin('absents','absents.employee_id','=','salaries.employee_id')
            ->leftjoin('offdays','offdays.employee_id','=','salaries.employee_id')
            ->leftjoin('leaves','leaves.employee_id','=','salaries.employee_id')
            ->leftjoin('departments','departments.id','=','employees.department')
            ->leftjoin('designations','designations.id','=','employees.designation')
            ->where(
                ['employees.unit'=>$request->unit_id,
                'nights.salary_month'=>$request->salary_month,
                'nights.salary_year'=>$request->salary_year,
                'absents.salary_month'=>$request->salary_month,
                'absents.salary_year'=>$request->salary_year,
                'offdays.salary_month'=>$request->salary_month,
                'offdays.salary_year'=>$request->salary_year,
                'leaves.salary_month'=>$request->salary_month,
                'leaves.salary_year'=>$request->salary_year
                ]
                )
            ->select('employees.*','nights.*','salaries.*','absents.abs_total_days','offdays.off_total_days','leaves.leave_total_days','departments.department_name','designations.designation_name')
            ->orderBy('departments.department_name')
            ->get();
            return view('admin.reports.pay_slip.pay_slip_report_full')
                    ->with('employees',$employees)
                    ->with('unit',$unit)
                    ->with('department',$department)
                    ->with('salaryDate',$salaryDate);
        }else{
        $employees = DB::table('employees')
        ->leftjoin('salaries','salaries.employee_id','=','employees.id_card_no') 
        ->leftjoin('nights','nights.employees_id','=','salaries.employee_id')
        ->leftjoin('absents','absents.employee_id','=','salaries.employee_id')
        ->leftjoin('offdays','offdays.employee_id','=','salaries.employee_id')
        ->leftjoin('leaves','leaves.employee_id','=','salaries.employee_id')
        ->leftjoin('departments','departments.id','=','employees.department')
        ->leftjoin('designations','designations.id','=','employees.designation')
        ->where(
            ['employees.unit'=>$request->unit_id,
            'employees.department'=>$request->department_id,
            'nights.salary_month'=>$request->salary_month,
            'nights.salary_year'=>$request->salary_year,
            'absents.salary_month'=>$request->salary_month,
            'absents.salary_year'=>$request->salary_year,
            'offdays.salary_month'=>$request->salary_month,
            'offdays.salary_year'=>$request->salary_year,
            'leaves.salary_month'=>$request->salary_month,
            'leaves.salary_year'=>$request->salary_year
            ]
            )
        ->select('employees.*','nights.*','salaries.*','absents.abs_total_days','offdays.off_total_days','leaves.leave_total_days','departments.department_name','designations.designation_name')
        ->orderBy('departments.department_name')
        ->get();


        return view('admin.reports.pay_slip.pay_slip_report')
                ->with('employees',$employees)
                ->with('unit',$unit)
                ->with('department',$department)
                ->with('salaryDate',$salaryDate);
        }
    }


    public function salarySummary(){
         $units = Unit::all();
         $departments = Department::all();

        return view('admin.reports.salary_summary.salary_summary')
        ->with('units',$units)
        ->with('departments',$departments);
    }











    public function salarySummaryReport(Request $request){
        return redirect('reports/salary_summary');
//         $unit           = Unit::find($request->unit_id);
//         $department     = Department::find($request->department_id);
        
//         $monthNum       = $request->salary_month +1;
//         $dateObj        = DateTime::createFromFormat('!m', $monthNum);
//         $monthName      = $dateObj->format('F');
//         $salaryDate     = $monthName."-".$request->salary_year;

//         if($request->department_id == "420"){
//             $department     = Department::all();
//             $employees = DB::table('employees')
//             ->where(
//                 ['employees.unit'=>$request->unit_id
//                 ]
//                 )
//             ->select('designation',DB::raw("count(distinct designation) as count"))
//             ->groupBy('designation')
//             ->get();

// return $employees;
//             return view('admin.reports.salary_summary.salary_summary_print')
//                     ->with('employees',$employees)
//                     ->with('unit',$unit)
//                     ->with('department',$department)
//                     ->with('salaryDate',$salaryDate);
//         }else{
//         $employees = DB::table('employees')
//         ->leftjoin('salaries','salaries.employee_id','=','employees.id_card_no') 
//         ->leftjoin('nights','nights.employees_id','=','salaries.employee_id')
//         ->leftjoin('absents','absents.employee_id','=','salaries.employee_id')
//         ->leftjoin('offdays','offdays.employee_id','=','salaries.employee_id')
//         ->leftjoin('leaves','leaves.employee_id','=','salaries.employee_id')
//         ->leftjoin('departments','departments.id','=','employees.department')
//         ->leftjoin('designations','designations.id','=','employees.designation')
//         ->where(
//             ['employees.unit'=>$request->unit_id,
//             'employees.department'=>$request->department_id,
//             'nights.salary_month'=>$request->salary_month,
//             'nights.salary_year'=>$request->salary_year,
//             'absents.salary_month'=>$request->salary_month,
//             'absents.salary_year'=>$request->salary_year,
//             'offdays.salary_month'=>$request->salary_month,
//             'offdays.salary_year'=>$request->salary_year,
//             'leaves.salary_month'=>$request->salary_month,
//             'leaves.salary_year'=>$request->salary_year
//             ]
//             )
//         ->select('employees.*','nights.*','salaries.*','absents.abs_total_days','offdays.off_total_days','leaves.leave_total_days','designations.designation_name','designations.designation_name')
//         ->get();

//         return $employees;
//          return view('admin.reports.salary_summary.salary_summary_print')
//                     ->with('employees',$employees)
//                     ->with('unit',$unit)
//                     ->with('department',$department)
//                     ->with('salaryDate',$salaryDate);
//         }
    }

}