<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Product;
use App\Models\ItemsReport;
use App\Models\Inventory;
use DB;

class ProductController extends Controller
{
    public function indexProduct(Request $request){

        $id = $request->user()->id;
        $users = User::where('id',$id)->get();
        foreach($users as $user){

        }

        global $user_id;
        global $c_id;
        global $c_secret;
        $c_id = $user->client_id;
        $c_secret = $user->client_secret;
        $user_id = $user->id;
      
        return $this->Report();

    }


    function getWalmartDetail()
	{
        global $c_id;
        global $c_secret;
		$data = [];	
		$data['client_id'] = $c_id;
		$data['client_secret'] = $c_secret;
		return $data;
	}

    function getToken()
	{
		$data = $this->getWalmartDetail();
		$client_id = $data['client_id'];
		$client_secret = $data['client_secret'];
		$url = "https://marketplace.walmartapis.com/v3/token";
		$uniqid = uniqid();
		$authorization_key = base64_encode($client_id.":".$client_secret);
		$code = "";

		$ch = curl_init();
		$options = array(

				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_TIMEOUT => 60,
				CURLOPT_HEADER => false,
				CURLOPT_POST =>1,
				CURLOPT_POSTFIELDS => "grant_type=client_credentials",
				CURLOPT_HTTPHEADER => array(

						"WM_SVC.NAME: Walmart Marketplace",
						"WM_QOS.CORRELATION_ID: $uniqid",
						"Authorization: Basic $authorization_key",
						"Accept: application/json",
						"Content-Type: application/x-www-form-urlencoded",
				),
		);
		curl_setopt_array($ch,$options);
		$response = curl_exec($ch);
		$code = curl_getinfo($ch,CURLINFO_HTTP_CODE);
		curl_close($ch);

		if($code == 201 || $code == 200)
		{
			$token = json_decode($response,true);
			return $token['access_token'];
		} 
	}

    public function Report(){

       
        $token = $this->getToken();
        $data = $this->getWalmartDetail();
         $client_id = $data['client_id'];
        $client_secret = $data['client_secret'];
        $authorization = base64_encode($client_id . ":" . $client_secret);
      
        $url =  "https://marketplace.walmartapis.com/v3/items?limit=1000";
    
        $ch      = curl_init();
        $qos     = uniqid();
        $options = array(
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT        => 60,
            CURLOPT_HEADER         => false,
            CURLOPT_HTTPHEADER     => array(
                "WM_SVC.NAME: Walmart Marketplace",
                "WM_QOS.CORRELATION_ID: $qos",
                "Authorization: Basic $authorization",
                "WM_SEC.ACCESS_TOKEN:$token",
                "Accept: application/json",
                "Content-Type: application/json",
            ),
            CURLOPT_HTTPGET        => true,
        );
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        $code     = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
    
        if ($code == 201 || $code == 200) {
              $response = json_decode($response,true);
            //   return view('admin.product.index', compact('response'));

           
              
            global $user_id;
              foreach($response['ItemResponse'] as $item => $value){
                
                $sku                = $value['sku'];
                // $upc                = $value['upc'];
                $gtin               = $value['gtin'];
                $product_name       = $value['productName'];
                $product_type       = $value['productType'];
                $current_price      = $value['price']['amount'];
                $published_status   = $value['publishedStatus'];
                
                if(Product::where('gtin', $gtin)->exists()) {
                  }else{
                    DB::table('products')
                    ->insert([
                    'user_id'               => $user_id,
                    'sku'                   => $sku,
                    // 'upc'                   => $upc,
                    'gtin'                  => $gtin,
                    'product_name'          => $product_name,
                    'product_type'          => $product_type,
                    'current_price'         => $current_price,
                    'published_status'      => $published_status
                   
                    ]);


                  }

               

              }
              
               return redirect('dashboard')->with('success','Sync Successfully!!');  

               
        } else {
            return redirect('dashboard')->with('error','Data not found!!'); 
        }

        
    }


    public function viewProduct(Request $request){
        $id = $request->user()->id;
        $response =  Inventory::where('inventories.user_id', $id)
        ->leftjoin('products','products.sku','=','inventories.item_sku')
        ->where('inventories.avai_sell_qty', '>=', 1)
        ->get();
        
        
        
      
        return view('admin.product.index', compact('response'));
    }
    
    
    public function stockValue(Request $request){
        
    $id = $request->user()->id;
        
    $response = ItemsReport::select(
    'items_reports.id as items_report_id',
    'items_reports.user_id',
    'items_reports.store_name',
    'items_reports.item_image',
    'items_reports.item_name',
    'items_reports.item_sku',
    'items_reports.item_price',
    'items_reports.item_inventory',
    'items_reports.item_buybox_price',
    'items_reports.item_id',
    'items_reports.item_upc',
    'items_reports.updated_at',
    'purchases.id as purchase_id',
    'purchases.user_id as purchase_user_id',
    'purchases.item_sku as purchase_item_sku',
    'purchases.suplier_name',
    'purchases.po_date',
    'purchases.item_qty',
    'purchases.line_total',
    'purchases.ship_prep_cost',
    'purchases.other_cost',
    'purchases.wfs_cost',
    'purchases.wfs_fee'
    )
    ->where('items_reports.user_id', $id)
    ->leftJoin('purchases', 'purchases.item_sku', '=', 'items_reports.item_sku')
    ->where('items_reports.item_inventory', '>=', 1)
    ->get();
    
    
    
    $upcomingValue =  DB::table('shipped_items')
    ->where(function($query) {
        $query->where('receivedQty', '=', 0)
              ->orWhereNull('receivedQty');
    })
    ->leftJoin('items_reports', 'items_reports.item_sku', '=', 'shipped_items.sku')
    ->leftJoin('purchases', 'purchases.item_sku', '=', 'shipped_items.sku')
    ->where('shipped_items.user_id', '=', $id)
    ->orderBy('shipped_items.expectedDeliveryDate', 'ASC')
    ->get();
    
    
    
    return view('admin.product.value', compact('response','upcomingValue'));
    }




}
