<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Employee;
use DB;

class NightController extends Controller
{
    public function addNight(Request $request){
    	$employees = DB::table('employees')
        ->join('designations','designations.id','=','employees.designation')
        ->where(['employees.id_card_no'=>$request->employeeId])
        ->select('employees.*','designations.designation_name')->get();
    	
    	if($employees->isEmpty()){
            return view('admin.night.add_night');
        }else{
            return view('admin.night.add_night')
            ->with('employees', $employees);
           
        }
    }

    public function saveNight(Request $request){
    	$condition = ['nights.employees_id'=>$request->employees_id,'nights.salary_year'=>$request->salary_year,'nights.salary_month'=>$request->salary_month];

    	$row = DB::table('nights')
        ->where($condition)->get();

        if ($row->isEmpty()) {
            $data = request()->except(['_token']);
            $row = DB::table('nights')->insert($data);
            return redirect('night/add_night')->with('success','Salary Add Successfully!!');
        } else {
        	$condition = ['nights.employees_id'=>$request->employees_id,'nights.salary_year'=>$request->salary_year,'nights.salary_month'=>$request->salary_month];
            DB::table('nights')
            ->where($condition)
            ->update([
                'employees_id'       => $request->employees_id,
                'salary_year'		 => $request->salary_year,
                'salary_month'		 => $request->salary_month,
                'bonus_amount'		 => $request->bonus_amount,
                'bonus_remarks'		 => $request->bonus_remarks,
                'night_amount'		 => $request->night_amount,
                'night_total'		 => $request->night_total,
                'night_remarks'		 => $request->night_remarks,
                'nightTotal_remarks' => $request->nightTotal_remarks,
                'total_net_amount'	 => $request->total_net_amount,
            	"updated_at" 		 =>  date('Y-m-d H:i:s')
                ]);
                return redirect('night/add_night')->with('success','Update Successfully!!');
        }

        
    }
   
}
