<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
class LeaveController extends Controller
{
     public function addLeaveday(Request $request){
        $employees = DB::table('employees')
        ->join('designations','designations.id','=','employees.designation')
        ->where(['employees.id_card_no'=>$request->employeeId])
        ->select('employees.*','designations.designation_name')->get();
    	
    	if($employees->isEmpty()){
            return view('admin.leave.add_leave');
        }else{
           return view('admin.leave.add_leave')
            ->with('employees', $employees);
           
        }
    }

    public function saveLeaveday(Request $request){
       $condition = ['leaves.employee_id'=>$request->employee_id,'leaves.salary_month'=>$request->salary_month,'leaves.salary_year'=>$request->salary_year];

        $row = DB::table('leaves')
        ->where($condition)->get();

          if($row->isEmpty()) {
            $data = request()->except(['_token']);
            $row = DB::table('leaves')->insert($data);
            return redirect()->back()->with('success','Add Successfully!!');
        } else {
            $condition = ['leaves.employee_id'=>$request->employee_id,'leaves.salary_month'=>$request->salary_month,'leaves.salary_year'=>$request->salary_year];
           
            DB::table('leaves')
            ->where($condition)
            ->update([
                'employee_id'       => $request->employee_id,
                'leave_position'    => $request->leave_position,
                'dates'             => $request->dates,
                'leave_total_days'  => $request->leave_total_days,
                'salary_month'      => $request->salary_month,
                'salary_year'       => $request->salary_year
            ]);

            return redirect()->back()->with('success','Update Successfully!!');
        }
    }
}
