<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Department;
use App\Models\Designation;
use App\Models\Employee;
use App\Models\Unit;
use Illuminate\Http\Request;
use DB;

class EmployeeController extends Controller
{
    public function index(){
        $employees = DB::table('employees')
        ->join('designations','designations.id','=','employees.designation')
        ->select('employees.*','designations.designation_name')->get();
     
    	return view('admin.employees.index')
        ->with('employees',$employees);
    }

    public function createEmployee(){
    	
        $designations    = Designation::orderBy('designation_name','ASC')->get();
        $departments     = Department::orderBy('department_name','ASC')->get();
        $units           = Unit::all();
      
        ///////////// start Auto Generate ID //////////////
        $existingId = 1000;
        $getExistingId = Employee::all();
        foreach ($getExistingId as $getId) {
            $existingId = $getId->id_card_no;
        }
        if($existingId !=""){
            $idFirstValue = $existingId+1;
            }else{
            $idFirstValue = 1000;
        }
       ///////////// end Auto Generate ID //////////////
       
    	return view('admin.employees.create')
        ->with('designations', $designations)
        ->with('departments', $departments)
        ->with('idFirstValue',$idFirstValue)
        ->with('units',$units);
    }
    public function saveEmployee(Request $request){
        $this->validate($request,[
         'employee_name'    =>'required',
         'join_date'        =>'required',
         'id_card_no'       =>'required',
         'employee_photo'   =>'image|mimes:jpeg,png,jpg,gif|max:2048'
      ]);

       if(Employee::where('id_card_no', $request->id_card_no)->exists()) {
         return redirect()->back()->with('error',$request->id_card_no.' Card No Adready Exits');
       }else{
        $input=$request->all();
        if ($request->hasFile('employee_photo')) {
            $file       =$request->file('employee_photo');
            $fileType   =$file->getClientOriginalExtension();
            $fileName   ="emp_".rand(1,1000).date('dmyhis').".".$fileType;
            $file->move('employee/photos',$fileName);
            $input['employee_photo']=$fileName;
        }
       try{
            Employee::create($input);
            return redirect()->back()->with('success', 'Employee add Successfully!!');
        }
        catch (\Exception $e){
            return redirect()->back()->with('error', 'Something went wrong!!!');
        }

       }
        
    }

    public function deleteEmployee($id){
        $employee   = Employee::find($id);
        $image_path = "employee/photos/".$employee->employee_photo; 
        if (file_exists($image_path)) {
             @unlink($image_path);
            }
        $employee->delete();
        return redirect('employee/index')->with('error','Delete Successfully!!');
    }

    public function editEmployee($id){
        $id             = \Crypt::decrypt($id);
        $units          = Unit::all();
        $designations   = Designation::all();
        $departments    = Department::all();

        $employees      = DB::table('employees')
        ->join('designations','designations.id','=','employees.designation')
        ->join('departments','departments.id','=','employees.department')
        ->join('units','units.id','=','employees.unit')
        ->where(['employees.id'=>$id])
        ->select('employees.*','designations.designation_name','departments.department_name','units.unit_name')->get();
        foreach($employees as $employee){

        }
       return view('admin.employees.edit')
       ->with('employee',$employee)
       ->with('units',$units)
       ->with('designations',$designations)
       ->with('departments',$departments); 
    }
    public function updateEmployee(Request $request){

        $employee = Employee::find($request->employee_id);
        
        $employee->employee_name    = $request->employee_name;
        $employee->join_date        = $request->join_date;
        $employee->id_card_no       = $request->id_card_no;
        $employee->employee_type    = $request->employee_type;
        $employee->gender           = $request->gender;
        $employee->ret_date         = $request->ret_date;
        $employee->father_name      = $request->father_name;
        $employee->mother_name      = $request->mother_name;
        $employee->merital_status   = $request->merital_status;
        $employee->date_of_birth    = $request->date_of_birth;
        $employee->nation           = $request->nation;
        $employee->religion         = $request->religion;
        $employee->nid_or_dob       = $request->nid_or_dob;
        $employee->unit             = $request->unit;
        $employee->designation      = $request->designation;
        $employee->department       = $request->department;
        $employee->duty_from        = $request->duty_from;
        $employee->duty_to          = $request->duty_to;
        $employee->phone            = $request->phone;
        $employee->email            = $request->email;
        $employee->back_account_no  = $request->back_account_no;
        $employee->present_address  = $request->present_address;
        $employee->permanent_address= $request->permanent_address;
        $employee->remarks          = $request->remarks;

        //Check Existing photo
        if($request->employee_photo != ''){ 
            $image_path = "employee/photos/".$employee->employee_photo; 
            if (file_exists($image_path)) {
                @unlink($image_path);
                }
            if ($request->hasFile('employee_photo')) {
                    $file=$request->file('employee_photo');
                    $fileType=$file->getClientOriginalExtension();
                    $fileName="emp_".rand(1,1000).date('dmyhis').".".$fileType;
                    $file->move('employee/photos',$fileName);
                    $employee->employee_photo = $fileName;
                    $employee->save();
        
            }
        }else{
    //for update in table
        $employee->save();
        }
       return redirect('employee/index')->with('success','Update Successfully!!');
        
    }

    public function viewEmployee($id){
        $id         = \Crypt::decrypt($id);
        $employees  = DB::table('employees')
        ->join('designations','designations.id','=','employees.designation')
        ->join('departments','departments.id','=','employees.department')
        ->join('units','units.id','=','employees.unit')
        ->where(['employees.id'=>$id])
        ->select('employees.*','designations.designation_name','departments.department_name','units.unit_name')->get();
        foreach($employees as $employee){

        }
       return view('admin.employees.view')
       ->with('employee',$employee); 
    }
}
