<?php

namespace App\Http\Controllers;

use App\Models\Department;
use Illuminate\Http\Request;

class DepartmentController extends Controller
{
    public function index(){
        $departments =  Department::orderBy('department_name','ASC')->get();
       return view('admin.settings.department.index',['departments'=>$departments]);
    }

    public function create(){

        return view('admin.settings.designation.create');
    }
    public function saveDepartment(Request $request){
        Department::create($request->all());
        return redirect('/settings/department/index')->with('success','Department Add Successfully!!');
        
    }

    public function editDepartment($id){
        $id = \Crypt::decrypt($id);
        $departments = Department::find($id);
        foreach($departments as $department){

        }
        return view('admin.settings.department.edit',['department'=>$department]);
    }

    public function updateDepartment(Request $request){
        $department = Department::find($request->department_id);
        $department->department_name = $request->department_name;
        $department->save();
        return redirect('/settings/department/index')->with('success','Department Update Successfully!!');
    }
    public function deleteDepartment($id){
        $department = Department::find($id);
        $department->delete();
        return redirect('/settings/department/index')->with('error','Department Delete Successfully!!');
    }
}
